/************************************************************************
 * NAME:	init.c
 *
 * DESCR:	Routines to initialize the HDOS fs.
 *
 * NOTES:	
 ************************************************************************/

#include "hdos.h"

/************************************************************************
 * NAME:	hdos_init()
 *
 * DESCR:	Initialize the hdos data structure.
 *
 * ARGS:	hdosfs is filled in
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
hdos_init(struct hdosfs *hdosfs, 
	  hdosdevice device, 
	  hdosreadfn readblkfn, 
	  hdoswritefn writeblkfn)
{
    hdosfs->device = device;
    hdosfs->preadsec = readblkfn;
    hdosfs->pwritesec = writeblkfn;

    hdos_dir_init(&hdosfs->dirbuf);

    return(TRUE);
}

int
hdos_settings(struct hdosfs	*hdosfs,
	      int		startsec,	/* physical start sect	*/
	      int		openfiles)	/* max open files	*/
{
    unsigned char	tmpRGT[200];

    hdosfs->startsec = startsec;

    hdos_label_read(hdosfs);

/****
 * M("label looks like\n");
 * {
 *     char buffer[2000];
 *
 *    hdos_label_report(hdosfs,buffer);
 *
 *    fprintf(stderr,"%s",buffer); fflush(stderr);
 * }
 ***/
 
    hdos_dir_read(hdosfs);
    hdos_grt_read(hdosfs);

    hdos_fileio_init(hdosfs,openfiles);

    hdos_rgt_read(hdosfs);	/* gets the template RGT if is one	*/
    hdos_rgt_compose(hdosfs,tmpRGT);	/* compose the real RGT		*/

    if (!hdos_rgt_ok(hdosfs,tmpRGT)) {
	M("Bad disk - overloaded groups.\n");
	return(FALSE);			/* this is a BAD disk		*/
    } else {
	hdos_rgt_install(hdosfs,tmpRGT);	/* install new RGT	*/
    }

    /* NOTE - at this point, there is a valid RGT that can be consulted.*/
    /*		However, HDOS_ISRGT() will still come back false.  This	*/
    /*		could be used when writing to decide whether to dump	*/
    /*		the RGT or not.						*/

    /* NOTE - the freelist as may currently be in the GRT is ignored.	*/
    /*		A new one is always built.				*/

    hdos_grt_build_freelist(hdosfs);

/*    if ((hdosfs->dirbuf = (struct directory *) malloc(hdosfs->maxdir*32)) == NULL ) {
	return(FALSE);
    }

    if ((hdosfs->c_iob = (C_FILE *) malloc(sizeof(C_FILE)*openfiles)) == NULL) {
	return(FALSE);
    }

    {
	int i;
	for( i=0; i < openfiles; i++) {
	    hdosfs->c_iob[i].c_flag = 0;
	}
    }

    if (!hdos_getdir(hdosfs)) {
	return(FALSE);
    }
    if (!hdos_build_bmap(hdosfs)) {
	return(FALSE);
    }
*/
    return(TRUE);
}


/************************************************************************
 * NAME:	hdos_cleanup()
 *
 * DESCR:	Frees any allocated structures.  This should really "flush"
 *		too.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
hdos_cleanup(struct hdosfs *hdosfs)
{
    hdos_dir_cleanup(&hdosfs->dirbuf);
    hdos_fileio_cleanup(hdosfs);

    return(TRUE);
}



